	function h = CIC_COMP_MF(K, N, Nc)
	
	% 	Computes a maximally flat FIR compensator filter 
	%	of length Nc for a Kth-order CIC filter with 
	%	with decimmation factor N
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Modified by:		LW 2012-03-03
	% 	Version:			1 
	% 	Known bugs:		
	% 	Report bugs to:		Wanhammar@gmail.com
	
	%	Reference:
	% 	G. Molnar and M. Vucic: Closed-form design of 
	%	CIC compensators based on maximally flat error 
	%	criterion, IEEE Trans. on Circuits and Systems, 
	%	II, Vol 58, No, 12, pp. 926-930, Dec. 2011.
	
	if mod(Nc,2) ~= 0	% Nc odd
		u = (1:(Nc-1)/2)'*ones(1,(Nc-1)/2);
		A = 2*(-1).^u.*(u').^(2*u);
		% The matrix A becomes ill-conditioned for high values of Nc > 18
		b = zeros((Nc-1)/2,1);
		for u = 1:(Nc-1)/2
			for q = 1:u
				x = (K*abs(BERNO(u-q+1))/2/(u-q+1)*(1-1/N^(2*(u-q+1))))^q;	 
				b(u) = b(u) +(2*q-1)*x;
			end
		end
		a = A\b;	
		a0 = 1-2*sum(a);
		h = [a(end:-1:1); a0;a];
	else	% Nc even
		u = (1:Nc/2)'*ones(1,Nc/2);
		A = 2*(-1).^(u-1).*(u'-1/2).^(2*u-2);
		b = [1;zeros(Nc/2-1,1)];
		for u = 2:Nc/2
			for q = 1:u-1
				x =(K*abs(BERNO(u-q))/2/(u-q)*(1-1/N^(2*(u-q))))^q;
				b(u) = b(u) +(2*q-1)*x;
			end
		end
		a = A\b;
		h = [a(end:-1:1);a];
	end
	
